<?php 
/** Common File 
 * 
 * @author  : Munir Sunni
 * @License To : PHP Infinite
 * 
 * This file is common file.
 */
@session_start();
@ob_start();
error_reporting (E_ALL ^ E_NOTICE);
// Include all the files 
include_once('connection.php');
include_once('messages.php');
include_once('functions.php');
include_once('path.php');
include_once('pagination.php');
date_default_timezone_set('Asia/Dubai');
// Include all the classes 
function __autoload($class_name){
    require_once(DIR_MODAL.'/'.$class_name.'.php');
}
$conn = new connection();
$conn->connect();
$settingObj = new setting();
$userObj = new user();
$settings = $settingObj->getAllRecords();
if($settings && count($settings) > 0){
	foreach ($settings as $setting){
		define($setting->setting_name, $setting->setting_value);
	}
}
switch (basename($_SERVER['PHP_SELF'])){
	case 'index.php' :
				$meta_title = DEFAULT_META_TITLE;
				$meta_ketwords = DEFAULT_META_KEYWORD;
				$meta_descriptions = DEFAULT_META_DESCRIPTION;
			break;
			
	default:
				$meta_title = DEFAULT_META_TITLE;
				$meta_ketwords = DEFAULT_META_KEYWORD;
				$meta_descriptions = DEFAULT_META_DESCRIPTION;
	break;	
}
if(isset($_POST['loginHeader'])){
	if($_POST['userType'] == 'user')
		$type = 'Free';
	else
		$type = 'Paid';
		
	if($_POST['userName']!='' && $_POST['password']!=''){
		$result = $userObj->checkLogin($_POST['userName'],md5($_POST['password']),$type);
		if($result){		
			$_SESSION['user'] = $result;
			if($_POST['userType'] == 'user')
				$_SESSION['user']->type = 'user';
			else
				$_SESSION['user']->type = 'paid_user';
				
			$loginDetail->user_id = $_SESSION['user']->user_id;
			$loginDetail->login_ip = $_SERVER['REMOTE_ADDR'];
			$loginDetail->login_time = date('Y-m-d H:i:s');
			$rs = $userObj->updateLastLoginDate();
			header('location:'.SITE_URL);
			exit;
		}else{
			$failedLoginMsg = "Invalid username or password.";		
		}
	}else{
		$failedLoginMsg = "Username and password are required.";		
	}
}
$countryArray = array("India", "Pakistan", "Bangladesh", "Sri Lanka", "United Arab Emirates", "Afghanistan", "Albania", "Algeria", "American Samoa", "Andorra", "Angola", "Anguilla", "Antarctica", "Antigua and Barbuda", "Argentina", "Armenia", "Aruba", "Australia", "Austria", "Azerbaijan", "Bahamas", "Bahrain", "Barbados", "Belarus", "Belgium", "Belize", "Benin", "Bermuda", "Bhutan", "Bolivia", "Bosnia and Herzegowina", "Botswana", "Bouvet Island", "Brazil", "British Indian Ocean Territory", "Brunei Darussalam", "Bulgaria", "Burkina Faso", "Burundi", "Cambodia", "Cameroon", "Canada", "Cape Verde", "Cayman Islands", "Central African Republic", "Chad", "Chile", "China", "Christmas Island", "Cocos (Keeling) Islands", "Colombia", "Comoros", "Congo", "Congo, the Democratic Republic of the", "Cook Islands", "Costa Rica", "Cote d'Ivoire", "Croatia (Hrvatska)", "Cuba", "Cyprus", "Czech Republic", "Denmark", "Djibouti", "Dominica", "Dominican Republic", "East Timor", "Ecuador", "Egypt", "El Salvador", "Equatorial Guinea", "Eritrea", "Estonia", "Ethiopia", "Falkland Islands (Malvinas)", "Faroe Islands", "Fiji", "Finland", "France", "France Metropolitan", "French Guiana", "French Polynesia", "French Southern Territories", "Gabon", "Gambia", "Georgia", "Germany", "Ghana", "Gibraltar", "Greece", "Greenland", "Grenada", "Guadeloupe", "Guam", "Guatemala", "Guinea", "Guinea-Bissau", "Guyana", "Haiti", "Heard and Mc Donald Islands", "Holy See (Vatican City State)", "Honduras", "Hong Kong", "Hungary", "Iceland", "Indonesia", "Iran (Islamic Republic of)", "Iraq", "Ireland", "Israel", "Italy", "Jamaica", "Japan", "Jordan", "Kazakhstan", "Kenya", "Kiribati", "Korea, Democratic People's Republic of", "Korea, Republic of", "Kuwait", "Kyrgyzstan", "Lao, People's Democratic Republic", "Latvia", "Lebanon", "Lesotho", "Liberia", "Libyan Arab Jamahiriya", "Liechtenstein", "Lithuania", "Luxembourg", "Macau", "Macedonia, The Former Yugoslav Republic of", "Madagascar", "Malawi", "Malaysia", "Maldives", "Mali", "Malta", "Marshall Islands", "Martinique", "Mauritania", "Mauritius", "Mayotte", "Mexico", "Micronesia, Federated States of", "Moldova, Republic of", "Monaco", "Mongolia", "Montserrat", "Morocco", "Mozambique", "Myanmar", "Namibia", "Nauru", "Nepal", "Netherlands", "Netherlands Antilles", "New Caledonia", "New Zealand", "Nicaragua", "Niger", "Nigeria", "Niue", "Norfolk Island", "Northern Mariana Islands", "Norway", "Oman", "Palau", "Panama", "Papua New Guinea", "Paraguay", "Peru", "Philippines", "Pitcairn", "Poland", "Portugal", "Puerto Rico", "Qatar", "Reunion", "Romania", "Russian Federation", "Rwanda", "Saint Kitts and Nevis", "Saint Lucia", "Saint Vincent and the Grenadines", "Samoa", "San Marino", "Sao Tome and Principe", "Saudi Arabia", "Senegal", "Seychelles", "Sierra Leone", "Singapore", "Slovakia (Slovak Republic)", "Slovenia", "Solomon Islands", "Somalia", "South Africa", "South Georgia and the South Sandwich Islands", "Spain",  "St. Helena", "St. Pierre and Miquelon", "Sudan", "Suriname", "Svalbard and Jan Mayen Islands", "Swaziland", "Sweden", "Switzerland", "Syrian Arab Republic", "Taiwan, Province of China", "Tajikistan", "Tanzania, United Republic of", "Thailand", "Togo", "Tokelau", "Tonga", "Trinidad and Tobago", "Tunisia", "Turkey", "Turkmenistan", "Turks and Caicos Islands", "Tuvalu", "Uganda", "Ukraine", "United Kingdom", "United States", "United States Minor Outlying Islands", "Uruguay", "Uzbekistan", "Vanuatu", "Venezuela", "Vietnam", "Virgin Islands (British)", "Virgin Islands (U.S.)", "Wallis and Futuna Islands", "Western Sahara", "Yemen", "Yugoslavia", "Zambia", "Zimbabwe");
?>